/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.enterprise.TransactionInformation;
import ca.sqlpower.enterprise.client.RevisionController;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class RevisionsTable
extends JTable {
    private static final String[] HEADERS = new String[]{"Version", "Time Created", "Author", "Description"};
    private RevisionController session;
    private List<TransactionInformation> transactions = new ArrayList<TransactionInformation>();
    private JScrollPane scrollPane;
    private final Action infoAction = new AbstractAction("Information"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int revisionNo = e.getID();
            JDialog d = SPSUtils.makeOwnedDialog((Component)RevisionsTable.this.getParent(), (String)("Revision " + revisionNo));
            d.setDefaultCloseOperation(2);
            d.setContentPane(new RevisionInformationPanel(revisionNo));
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.setPreferredSize(new Dimension(600, 300));
            d.pack();
            d.setLocationRelativeTo(RevisionsTable.this.getParent());
            d.setVisible(true);
        }
    };

    public RevisionsTable(RevisionController session, long fromRevision, long toRevision) {
        this.session = session;
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setAutoscrolls(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setAutoResizeMode(0);
        ListSelectionModel selectionModel = this.getSelectionModel();
        selectionModel.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new NoFocusTableCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && RevisionsTable.this.getSelectedRow() != -1) {
                    int revisionNo = RevisionsTable.this.getSelectedRevisionNumber();
                    RevisionsTable.this.infoAction.actionPerformed(new ActionEvent(this, revisionNo, null));
                }
            }
        });
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setPreferredSize(new Dimension(2000, 2000));
        this.refreshRevisionsList(fromRevision, toRevision);
    }

    public void refreshRevisionsList(long fromRevision, long toRevision) {
        int i;
        Object[][] data = new String[][]{{""}};
        int selected = this.getSelectedRow();
        Font f = new DefaultTableCellRenderer().getFont();
        FontMetrics fm = new DefaultTableCellRenderer().getFontMetrics(f);
        int[] maxWidth = new int[HEADERS.length];
        for (i = 0; i < HEADERS.length; ++i) {
            maxWidth[i] = fm.stringWidth(HEADERS[i]);
        }
        try {
            this.transactions = this.session.getTransactionList(fromRevision, toRevision);
            data = new String[this.transactions.size()][HEADERS.length];
            for (i = 0; i < this.transactions.size(); ++i) {
                TransactionInformation transaction = this.transactions.get(i);
                data[i][0] = String.valueOf(transaction.getVersionNumber()) + " ";
                data[i][1] = TransactionInformation.DATE_FORMAT.format(transaction.getTimeCreated()) + " ";
                data[i][2] = transaction.getVersionAuthor() + " ";
                data[i][3] = transaction.getSimpleDescription();
                for (int j = 0; j < HEADERS.length; ++j) {
                    int cellWidth = fm.stringWidth((String)data[i][j]);
                    if (cellWidth <= maxWidth[j]) continue;
                    maxWidth[j] = cellWidth;
                }
            }
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException("Error getting revision list from server ", e);
            }
            catch (Throwable throwable) {
                this.setModel(new DefaultTableModel(data, HEADERS){

                    @Override
                    public boolean isCellEditable(int x, int y) {
                        return false;
                    }
                });
                for (int i2 = 0; i2 < HEADERS.length; ++i2) {
                    this.getColumnModel().getColumn(i2).setPreferredWidth(maxWidth[i2]);
                }
                if (selected < data.length && selected != -1) {
                    this.setRowSelectionInterval(selected, selected);
                }
                NoFocusTableCellRenderer r = new NoFocusTableCellRenderer();
                r.setHorizontalAlignment(4);
                this.getColumnModel().getColumn(0).setCellRenderer(r);
                JScrollBar v = this.scrollPane.getVerticalScrollBar();
                SwingUtilities.invokeLater(new Runnable(v){
                    final /* synthetic */ JScrollBar val$v;
                    {
                        this.val$v = jScrollBar;
                    }

                    @Override
                    public void run() {
                        this.val$v.setValue(this.val$v.getMaximum());
                    }
                });
                throw throwable;
            }
        }
        this.setModel(new /* invalid duplicate definition of identical inner class */);
        for (i = 0; i < HEADERS.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(maxWidth[i]);
        }
        if (selected < data.length && selected != -1) {
            this.setRowSelectionInterval(selected, selected);
        }
        NoFocusTableCellRenderer r = new NoFocusTableCellRenderer();
        r.setHorizontalAlignment(4);
        this.getColumnModel().getColumn(0).setCellRenderer(r);
        JScrollBar v = this.scrollPane.getVerticalScrollBar();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public TransactionInformation getRevisionInformation(int revisionNo) {
        for (TransactionInformation transaction : this.transactions) {
            if (transaction.getVersionNumber() != (long)revisionNo) continue;
            return transaction;
        }
        return null;
    }

    public int getSelectedRevisionNumber() {
        int headersColumn = 0;
        for (int i = 0; i < HEADERS.length; ++i) {
            if (!HEADERS[i].contains("Version")) continue;
            headersColumn = i;
        }
        String number = (String)this.getModel().getValueAt(this.getSelectedRow(), headersColumn);
        return Integer.parseInt(number.trim());
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private class NoFocusTableCellRenderer
    extends DefaultTableCellRenderer {
        private NoFocusTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    private class RevisionInformationPanel
    extends JPanel {
        public RevisionInformationPanel(int revisionNo) {
            super(new BorderLayout());
            TransactionInformation info = RevisionsTable.this.getRevisionInformation(revisionNo);
            JTextArea infoArea = new JTextArea();
            infoArea.setMargin(new Insets(6, 10, 4, 6));
            infoArea.setEditable(false);
            infoArea.append("Revision " + revisionNo);
            infoArea.append("\n\nAuthor: " + info.getVersionAuthor());
            infoArea.append("\nTime created: " + new Date(info.getTimeCreated()));
            String description = "";
            for (String line : info.getSimpleDescription().split(", ")) {
                description = description + "\n" + line;
            }
            infoArea.append("\n\nDescription:" + description);
            final JScrollPane sp = new JScrollPane(infoArea);
            this.add(sp);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sp.getHorizontalScrollBar().setValue(sp.getHorizontalScrollBar().getMinimum());
                    sp.getVerticalScrollBar().setValue(sp.getVerticalScrollBar().getMinimum());
                }
            });
        }
    }
}

