/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.Set;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.SolrCollection;
import org.apache.solr.cluster.placement.BalanceRequest;
import org.apache.solr.cluster.placement.impl.SimpleClusterAbstractionsImpl;

public class BalanceRequestImpl
implements BalanceRequest {
    private final SolrCollection solrCollection;
    private final Set<Node> nodes;
    private final int maximumBalanceSkew;

    public BalanceRequestImpl(Set<Node> nodes) {
        this(nodes, -1);
    }

    public BalanceRequestImpl(Set<Node> nodes, int maximumBalanceSkew) {
        this.nodes = nodes;
        this.maximumBalanceSkew = maximumBalanceSkew;
        this.solrCollection = null;
    }

    @Override
    public Set<Node> getNodes() {
        return this.nodes;
    }

    @Override
    public int getMaximumBalanceSkew() {
        return this.maximumBalanceSkew;
    }

    @Override
    public SolrCollection getCollection() {
        return this.solrCollection;
    }

    static BalanceRequestImpl create(Cluster cluster, Set<String> nodeNames, int maximumBalanceSkew) throws Assign.AssignmentException {
        Set<Node> nodes;
        if (nodeNames != null && !nodeNames.isEmpty()) {
            if (nodeNames.size() == 1) {
                throw new Assign.AssignmentException("Bad balance request: cannot balance across a single node: " + (String)nodeNames.stream().findAny().get());
            }
            nodes = SimpleClusterAbstractionsImpl.NodeImpl.getNodes(nodeNames);
            for (Node n : nodes) {
                if (cluster.getLiveDataNodes().contains(n)) continue;
                throw new Assign.AssignmentException("Bad balance request: specified node is a non-data hosting node:" + n.getName());
            }
        } else {
            nodes = cluster.getLiveDataNodes();
            if (nodes.isEmpty()) {
                throw new Assign.AssignmentException("Impossible balance request: no live data nodes");
            }
        }
        return new BalanceRequestImpl(nodes, maximumBalanceSkew);
    }
}

