/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.start.PathMatchers;
import org.eclipse.jetty.start.StartLog;

public class PathFinder
extends SimpleFileVisitor<Path> {
    private static Set<Path> NOTIFIED_PATHS = new HashSet<Path>();
    private boolean includeDirsInResults = false;
    private Map<String, Path> hits = new HashMap<String, Path>();
    private Path basePath = null;
    private PathMatcher dirMatcher = PathMatchers.getNonHidden();
    private PathMatcher fileMatcher = PathMatchers.getNonHidden();

    private void addHit(Path path) {
        String relPath = this.basePath.relativize(path).toString();
        StartLog.debug("Found [" + relPath + "]  " + String.valueOf(path), new Object[0]);
        this.hits.put(relPath, path);
    }

    public PathMatcher getDirMatcher() {
        return this.dirMatcher;
    }

    public PathMatcher getFileMatcher() {
        return this.fileMatcher;
    }

    public List<File> getHitList() {
        ArrayList<File> ret = new ArrayList<File>();
        for (Path path : this.hits.values()) {
            ret.add(path.toFile());
        }
        return ret;
    }

    public Collection<Path> getHits() {
        return this.hits.values();
    }

    public boolean isIncludeDirsInResults() {
        return this.includeDirsInResults;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.dirMatcher.matches(dir)) {
            StartLog.trace("Following dir: " + String.valueOf(dir), new Object[0]);
            if (this.includeDirsInResults && this.fileMatcher.matches(dir)) {
                this.addHit(dir);
            }
            return FileVisitResult.CONTINUE;
        }
        StartLog.trace("Skipping dir: " + String.valueOf(dir), new Object[0]);
        return FileVisitResult.SKIP_SUBTREE;
    }

    public void setBase(Path basePath) {
        this.basePath = basePath;
    }

    public void setDirMatcher(PathMatcher dirMatcher) {
        this.dirMatcher = dirMatcher;
    }

    public void setFileMatcher(PathMatcher fileMatcher) {
        this.fileMatcher = fileMatcher;
    }

    public void setFileMatcher(String pattern) {
        this.fileMatcher = PathMatchers.getMatcher(pattern);
    }

    public void setIncludeDirsInResults(boolean includeDirsInResults) {
        this.includeDirsInResults = includeDirsInResults;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.fileMatcher.matches(file)) {
            this.addHit(file);
        } else {
            StartLog.trace("Ignoring file: " + String.valueOf(file), new Object[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        if (exc instanceof FileSystemLoopException) {
            if (!NOTIFIED_PATHS.contains(file)) {
                StartLog.warn("skipping detected filesystem loop: " + String.valueOf(file), new Object[0]);
                NOTIFIED_PATHS.add(file);
            }
            return FileVisitResult.SKIP_SUBTREE;
        }
        StartLog.warn(exc);
        return super.visitFileFailed(file, exc);
    }
}

