untrusted comment: verify with openbsd-75-base.pub
RWRGj1pRpprAfq1RsGGLhd13uQfrECNsJMvb/8XuZMlT/IHHS9qz6djLE22Ix3wj6y41Pqmio4+jSGDBEK3utB2mTQf21QA5mAs=

OpenBSD 7.5 errata 010, September 17, 2024:

Invalid ELF files could result in kernel crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-75-base.pub -x 010_elf.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/exec_elf.c
===================================================================
RCS file: /cvs/src/sys/kern/exec_elf.c,v
diff -u -p -u -r1.185 exec_elf.c
--- sys/kern/exec_elf.c	17 Jan 2024 22:22:25 -0000	1.185
+++ sys/kern/exec_elf.c	15 Sep 2024 13:17:54 -0000
@@ -310,8 +310,10 @@ elf_read_pintable(struct proc *p, struct
 	for (i = 0; i < nsyscalls; i++) {
 		if (syscalls[i].sysno <= 0 ||
 		    syscalls[i].sysno >= SYS_MAXSYSCALL ||
-		    syscalls[i].offset > len)
+		    syscalls[i].offset > len) {
+			npins = 0;
 			goto bad;
+		}
 		npins = MAX(npins, syscalls[i].sysno);
 	}
 	if (is_ldso)
